
library(memisc)


library(mclogit)


load("model-relmemb-galtan-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_galtan <- mtable(model_galtan,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "GAL--TAN" = c("Squared" = "galtan.sq",                        
                                                "Linear"  = "galtan",                           
                                                "$\\times$ non-Christian"  = "galtan:relmembNon-Christian",      
                                                "$\\times$ no religion"    = "galtan:relmembNo religion",        
                                                "$\\times$ self-employed"  = "galtan:oesch8Self-employed",       
                                                "$\\times$ technical"      = "galtan:oesch8Technical",           
                                                "$\\times$ management"     = "galtan:oesch8Management",          
                                                "$\\times$ clerks"         = "galtan:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "galtan:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "galtan:oesch8Service worker",      
                                                "$\\times$ primary sector" = "galtan:oesch8Primary sector",      
                                                "$\\times$ secularization" = "galtan:Secularization", 
                                                "$\\times$ non-Christian $\\times$ secularization"  = "galtan:relmembNon-Christian:Secularization", 
                                                "$\\times$ no religion $\\times$ secularization"    = "galtan:relmembNo religion:Secularization",
                                                "$\\times$ time" = "galtan:time", 
                                                "$\\times$ non-Christian $\\times$ time"  = "galtan:relmembNon-Christian:time", 
                                                "$\\times$ no religion $\\times$ time"    = "galtan:relmembNo religion:time",
                                                "$\\times$ self-employed $\\times$ time"  = "galtan:oesch8Self-employed:time",  
                                                "$\\times$ technical $\\times$ time"      = "galtan:oesch8Technical:time",      
                                                "$\\times$ management $\\times$ time"     = "galtan:oesch8Management:time",     
                                                "$\\times$ clerks $\\times$ time"         = "galtan:oesch8Clerks:time",         
                                                "$\\times$ socio-cultural $\\times$ time" = "galtan:oesch8Socio-cultural:time", 
                                                "$\\times$ service worker $\\times$ time" = "galtan:oesch8Service worker:time", 
                                                "$\\times$ primary sector $\\times$ time" = "galtan:oesch8Primary sector:time"),                                  
                            "Economic Left--Right"= c("Squared" = "lrecon.sq",                                 
                                                  "Linear"  = "lrecon",                                         
                                                 "$\\times$ non-Christian"  = "relmembNon-Christian:lrecon",               
                                                 "$\\times$ no religion"    = "relmembNo religion:lrecon",                                    
                                                 "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",                     
                                                 "$\\times$ technical"      = "oesch8Technical:lrecon",                         
                                                 "$\\times$ management"     = "oesch8Management:lrecon",                        
                                                 "$\\times$ clerks"         = "oesch8Clerks:lrecon",                            
                                                 "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",                    
                                                 "$\\times$ service worker" = "oesch8Service worker:lrecon",                    
                                                 "$\\times$ primary sector" = "oesch8Primary sector:lrecon",                    
                                                 "$\\times$ time" = "time:lrecon",          
                                                 "$\\times$ non-Christian $\\times$ time"  = "relmembNon-Christian:time:lrecon",          
                                                 "$\\times$ no religion $\\times$ time"    = "relmembNo religion:time:lrecon",                                    
                                                 "$\\times$ self-employed $\\times$ time"  = "oesch8Self-employed:time:lrecon",                
                                                 "$\\times$ technical $\\times$ time"      = "oesch8Technical:time:lrecon",                    
                                                 "$\\times$ management $\\times$ time"     = "oesch8Management:time:lrecon",                   
                                                 "$\\times$ clerks $\\times$ time"         = "oesch8Clerks:time:lrecon",                       
                                                 "$\\times$ socio-cultural $\\times$ time" = "oesch8Socio-cultural:time:lrecon",               
                                                 "$\\times$ service worker $\\times$ time" = "oesch8Service worker:time:lrecon",               
                                                 "$\\times$ primary sector $\\times$ time" = "oesch8Primary sector:time:lrecon")
                        )))



m_galtan


m_galtan |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="relmemb-context-galtan/mtable-relmemb-context-galtan.tex")




